import React from "react";
import image1 from "../../../../public/assets/home/featureVideos/image1.jpg";
import image2 from "../../../../public/assets/home/featureVideos/image2.jpg";
import image3 from "../../../../public/assets/home/featureVideos/image3.png";
import image4 from "../../../../public/assets/home/featureVideos/image4.png";
import image5 from "../../../../public/assets/home/featureVideos/image5.png";
import image6 from "../../../../public/assets/home/featureVideos/image6.png";
import grow from "../../../../public/assets/home/featureVideos/grow.png";
import certifications from "../../../../public/assets/home/featureVideos/certifications.png";
import Link from "next/link";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faGraduationCap,
  faClock,
  faCheck,
} from "@fortawesome/free-solid-svg-icons";
import Image from "next/image";

function FeaturedVideos() {

  const data = [
    {
      img: image1,
      text: "by Determined-Poitras",
      title: "Bespoke – Add Storytelling to Your Real Estate Videos",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image2,
      text: "by Determined-Poitras",
      title: "Brandon Bames – Make It Unique",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image3,
      text: "by Determined-Poitras",
      title: "The Corcoran Group – Focus on the Main Attractions",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image4,
      text: "by Determined-Poitras",
      title: "MGroup – Appeal to Sellers Too",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image5,
      text: "by Determined-Poitras",
      title: "Haus – Educate Your Audience",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image6,
      text: "by Determined-Poitras",
      title: "Never Too Small – Give Every House a Shot (Pun Intended)",
      weeks: "2Weeks",
      students: "156 Students",
    },
  ];

  const userData = [
    {
      num: "25K+",
      text: "Active Users",
    },
    {
      num: "899",
      text: "Total Videos",
    },
    {
      num: "158",
      text: "Instructor",
    },
    {
      num: "100%",
      text: "Satisfaction rate",
    },
  ];

  return (
    <div className="max-w-7xl p-8 mx-auto">
      <div>
        <div className="flex justify-between flex-col gap-4 sm:gap-0 sm:flex-row py-6">
          <div>
            <h1 className="font-bold text-3xl">Featured Videos</h1>
            <p className="text-darkgrey font-normal text-[18px]">
              Explore our Popular Videos
            </p>
          </div>
          <div>
            <button className="text-[18px] font-medium border-2 border-grey p-3 rounded-full">
              All Videos
            </button>
          </div>
        </div>
        <div className="flex justify-center items-center">
          <div className="grid justify-center grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-y-5 lg:gap-x-6 md:gap-x-4">
            {data?.length &&
              data?.map((data, index) => (
                <div
                  key={index}
                  className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105  max-w-sm bg-white border border-gray-200 rounded-[30px] shadow"
                >
                  <div className="relative">
                    <Image
                      className="rounded-t-[30px] object-cover"
                      src={data?.img}
                      alt="image"
                      objectFit="cover"
                      width={500}
                      height={200}
                    />
                    <button className="absolute top-4 left-4 bg-black text-white py-2 px-3 rounded-xl">
                      Realtor Promotion
                    </button>
                  </div>
                  <div>
                    <div className="px-5">
                      <p className="mb-3 mt-3 font-normal text-gray-700 dark:text-gray-400">
                        {data?.text}
                      </p>
                      <h5 className="mb-2 text-2xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                        {data?.title}
                      </h5>
                    </div>
                    <div className="flex p-5 gap-3">
                      <div className="flex gap-1 justify-center items-center">
                        <FontAwesomeIcon
                          icon={faClock}
                          className="text-[#B9802A]"
                        />
                        <span className="font-normal">{data?.weeks}</span>
                      </div>
                      <div className="flex gap-1 justify-center items-center">
                        <FontAwesomeIcon
                          icon={faGraduationCap}
                          className="text-golden"
                        />
                        <span className="font-normal">{data?.students}</span>
                      </div>
                    </div>
                    <div className="bg-[#EAEAEA] h-[1px] mx-4"></div>
                    <div className="flex justify-end p-2">
                      <Link
                        href="#"
                        className="inline-flex items-center px-3 py-2 text-sm font-medium text-center text-[18px]"
                      >
                        View more
                      </Link>
                    </div>
                  </div>
                </div>
              ))}
          </div>
        </div>
      </div>
      <div className="bg-gradient-to-r from-darkblue to-lightblue min-h-[310px] rounded-2xl my-16">
        <div className="flex flex-col-reverse lg:flex-row justify-between gap-4 h-full">
          <div className=" flex flex-col gap-3 items-start max-w-[440px] p-8 lg:pt-12 pl-4 md:pl-10 h-full">
            <p className="font-semibold text-[#EBEBEB]">GET MORE POWER FROM </p>
            <h1 className="text-[#FFFFFF] text-3xl ">
              Agent Ambition Academy Certifications
            </h1>
            <p className="text-[#D9D9D9] font-normal">
              The next level of Agent Ambition Academy. More Powerful, Flexible
              and Magical Inside.
            </p>
            <button className=" bg-golden text-white py-3 px-4 rounded-xl text-[18px] font-medium">
              Explorer course
            </button>
          </div>
          <div className="flex justify-center items-center  h-full lg:w-3/5">
            <Image
              src={certifications}
              className="object-cover h-full w-full"
              alt="cerificaions"
            />
          </div>
        </div>
      </div>
      <div className="flex justify-center items-center">
        <div className="grid justify-center items-center place-items-center grid-cols-2 md:grid-cols-2 xl:grid-cols-4 gap-y-5 l:gap-x-6 gap-x-4">
          {userData?.length &&
            userData?.map((userData, index) => (
              <div
                key={index}
                className="flex gap-4 items-center p-3 bg-whitegrey rounded-md shadow min-w-[150px] sm:min-w-[200px] md:min-w-[250px] max-w-[300px] h-[180px]"
              >
                <div className="flex flex-col gap-2 justify-center items-center w-[100%]">
                  <p className="text-golden font-semibold text-3xl">
                    {userData?.num}
                  </p>
                  <p className="text-black font-medium text-[18px]">
                    {userData?.text}
                  </p>
                </div>
              </div>
            ))}
        </div>
      </div>
      <div className="flex flex-col lg:flex-row justify-between gap-4 my-10">
        <div className="flex justify-center items-center">
          <Image src={grow} className="object-cover" alt="grow-skills" />
        </div>
        <div className="flex justify-center">
          <div className="max-w-[520px]">
            <h1 className="text-[32px] font-bold">Grow Us Your Skill </h1>
            <h1 className="text-[32px] font-bold">
              With Agent Ambition Academy
            </h1>
            <p className="my-2">
              We denounce with righteous indignation and dislike men who are so
              beguiled and demoralized that cannot trouble.
            </p>
            <div className="flex flex-col gap-2">
              <div className="flex items-center gap-2">
                <FontAwesomeIcon
                  icon={faCheck}
                  className="text-lightblue text-[16px]"
                />
                <span>Certification</span>
              </div>
              <div className="flex items-center gap-2">
                <FontAwesomeIcon
                  icon={faCheck}
                  className="text-lightblue text-[16px]"
                />
                <span>Certification</span>
              </div>
              <div className="flex items-center gap-2">
                <FontAwesomeIcon
                  icon={faCheck}
                  className="text-lightblue text-[16px]"
                />
                <span>Certification</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default FeaturedVideos;